/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.debug.ui.console;

import com.aptana.debug.ui.DebugUiPlugin;
import com.aptana.debug.ui.SourceDisplayUtil;
import com.aptana.debug.ui.console.Messages;
import com.aptana.ui.util.UIUtils;
import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.TextConsole;

public class ConsoleHyperlink
implements IHyperlink {
    private TextConsole fConsole;
    private String fFilename;
    private int fLineNumber;

    public ConsoleHyperlink(TextConsole console, String fileName, int lineNumber) {
        this.fConsole = console;
        this.fFilename = fileName;
        this.fLineNumber = lineNumber;
    }

    public void linkEntered() {
    }

    public void linkExited() {
    }

    public void linkActivated() {
        try {
            Object sourceElement = DebugUITools.lookupSource((Object)this.fFilename, (ISourceLocator)this.getSourceLocator()).getSourceElement();
            IEditorInput editorInput = SourceDisplayUtil.getEditorInput(sourceElement);
            if (editorInput != null) {
                SourceDisplayUtil.openInEditor(editorInput, this.fLineNumber);
                return;
            }
            MessageDialog.openInformation((Shell)UIUtils.getActiveShell(), (String)Messages.ConsoleHyperlink_SourceNotFound_Title, (String)MessageFormat.format(Messages.ConsoleHyperlink_SourceNotFound_Message, this.fFilename));
        }
        catch (CoreException e) {
            DebugUiPlugin.errorDialog("An exception occurred while following link.", e);
        }
    }

    private ISourceLocator getSourceLocator() {
        ILaunch launch;
        ISourceLocator sourceLocator = null;
        IProcess process = (IProcess)this.getConsole().getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_PROCESS");
        if (process != null && (launch = process.getLaunch()) != null) {
            sourceLocator = launch.getSourceLocator();
        }
        return sourceLocator;
    }

    private TextConsole getConsole() {
        return this.fConsole;
    }
}

